<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * Compatibilty with WPML plugins
 *
 * @package porto
 * @since 7.2.0
 */

if ( ! class_exists( 'Porto_WPML' ) ) :
	class Porto_WPML {
		/**
		 * Constructor
		 */
		public function __construct() {
			if ( ! defined( 'WCML_VERSION' ) || ! defined( 'ICL_SITEPRESS_VERSION' ) ) {
				return;
			}

			$this->init();
		}

		/**
		 * Init
		 */
		public function init() {
			add_filter( 'wcml_multi_currency_ajax_actions', array( $this, 'ajax_actions' ), 10, 1 );
		}

		public function ajax_actions( $ajax_actions ) {
			$ajax_actions[] = 'porto_add_to_cart';
			$ajax_actions[] = 'porto_product_quickview';
			$ajax_actions[] = 'porto_recent_sale_products';
			$ajax_actions[] = 'porto_ajax_posts';
			$ajax_actions[] = 'porto_cart_item_remove';
			$ajax_actions[] = 'porto_refresh_cart_fragment';
			$ajax_actions[] = 'porto_woocommerce_shortcodes_products';
			$ajax_actions[] = 'porto_update_cart_item';
			$ajax_actions[] = 'porto_refresh_wishlist_count';
			$ajax_actions[] = 'porto_load_wishlist';

			return $ajax_actions;
		}
	}

	new Porto_WPML;
endif;
